package org.example;

import org.example.todo.Todo;
import org.example.todo.TodoList;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;

@Component
public class TodoCLI implements CommandLineRunner {

	private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

	private final TodoList todoList;

	public TodoCLI(TodoList todoList) {
		this.todoList = todoList;
	}

	@Override
	public void run(String[] args) {
		Scanner scanner = new Scanner(System.in);
		while (true) {
			System.out.println();
			System.out.println("1 List Todos");
			System.out.println("2 Add Todo");
			System.out.println("3 Complete Todo");
			System.out.println("4 Remove Todo");
			System.out.println("x Exit");
			System.out.print("> ");
			try {
				switch (scanner.nextLine()) {
					case "1" -> todoList.getTodos().forEach(this::printTodo);
					case "2" -> {
						System.out.print("Title:    ");
						String title = scanner.nextLine();
						if (title.isEmpty())
							throw new IllegalArgumentException("Title must not be empty");
						System.out.print("Due Date: ");
						String line = scanner.nextLine();
						Date dueDate = line.isEmpty() ? null : dateFormat.parse(line);
						long id = todoList.addTodo(title, dueDate);
						System.out.println("Todo " + id + " added");
					}
					case "3" -> {
						System.out.print("Id: ");
						long id = Long.parseLong(scanner.nextLine());
						Todo todo = todoList.findTodo(id);
						todo.setCompleted(true);
						todoList.updateTodo(todo);
						System.out.println("Todo " + id + " completed");
					}
					case "4" -> {
						System.out.print("Id: ");
						long id = Long.parseLong(scanner.nextLine());
						todoList.removeTodo(id);
						System.out.println("Todo " + id + " removed");
					}
					case "x" -> System.exit(0);
					default -> System.out.println("Error: Invalid choice");
				}
			} catch (NumberFormatException ex) {
				System.out.println("Error: Invalid input");
			} catch (ParseException ex) {
				System.out.println("Error: Invalid date");
			} catch (Exception ex) {
				System.out.println("Error: " + ex.getMessage());
			}
		}
	}

	private void printTodo(Todo todo) {
		System.out.println("Todo " + todo.getId() + ": " + todo.getTitle() + ", " +
				(todo.getDueDate() != null ? dateFormat.format(todo.getDueDate()) + ", " : "") +
				(todo.isCompleted() ? "completed" : "pending"));
	}
}
