package org.example.todo;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.ProblemDetail;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

@Component
public class TodoListProxy implements TodoList {

	@Value("${service.baseUrl}")
	private String baseUrl;

	private final RestTemplate restTemplate;

	public TodoListProxy(RestTemplateBuilder builder) {
		restTemplate = builder.build();
	}

	public List<Todo> getTodos() {
		return Arrays.asList(restTemplate.getForObject(baseUrl, Todo[].class));
	}

	public Todo findTodo(long id) throws TodoNotFoundException {
		try {
			return restTemplate.getForObject(baseUrl + "/" + id, Todo.class);
		} catch (HttpClientErrorException.NotFound ex) {
			throw new TodoNotFoundException(ex.getResponseBodyAs(ProblemDetail.class).getDetail());
		}
	}

	public long addTodo(String title, Date dueDate) {
		return restTemplate.postForObject(baseUrl, new Todo(title, dueDate), Long.class);
	}

	public void updateTodo(Todo todo) throws TodoNotFoundException {
		try {
			restTemplate.put(baseUrl + "/" + todo.getId(), todo);
		} catch (HttpClientErrorException.NotFound ex) {
			throw new TodoNotFoundException(ex.getResponseBodyAs(ProblemDetail.class).getDetail());
		}
	}

	public void removeTodo(long id) {
		restTemplate.delete(baseUrl + "/" + id);
	}
}
