package org.example.filter;

import org.springframework.stereotype.Component;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

import static jakarta.servlet.http.HttpServletResponse.SC_UNAUTHORIZED;

@Component
public class AuthFilter extends HttpFilter {

	private static final String AUTH_TOKEN = "12345678";

	@Override
	public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain)
			throws IOException, ServletException {
		String header = request.getHeader("AuthToken");
		if (header == null)
			response.sendError(SC_UNAUTHORIZED, "Missing authentication token");
		else if (!header.equals(AUTH_TOKEN))
			response.sendError(SC_UNAUTHORIZED, "Invalid authentication token");
		else chain.doFilter(request, response);
	}
}
