package org.example.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@Component
@Order(1)
public class LogFilter extends HttpFilter {

	private static final Logger log = LoggerFactory.getLogger(LogFilter.class);

	@Override
	protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain)
			throws IOException, ServletException {
		log.info("Request: {} {}", request.getMethod(), request.getRequestURI());
		try {
			chain.doFilter(request, response);
		} finally {
			log.info("Response: {}", HttpStatus.valueOf(response.getStatus()));
		}
	}
}
