package org.example.todo;

import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;

public class TodoCSVMessageConverter implements HttpMessageConverter<List<Todo>> {

	private static final MediaType TEXT_CSV = new MediaType("text", "csv");

	@Override
	public List<MediaType> getSupportedMediaTypes() {
		return Collections.singletonList(TEXT_CSV);
	}

	@Override
	public boolean canRead(Class<?> clazz, MediaType mediaType) {
		return false;
	}

	@Override
	public boolean canWrite(Class<?> clazz, MediaType mediaType) {
		return List.class.isAssignableFrom(clazz) && mediaType.equals(TEXT_CSV);
	}

	@Override
	public List<Todo> read(Class<? extends List<Todo>> clazz, HttpInputMessage message) throws HttpMessageNotReadableException {
		return null;
	}

	@Override
	public void write(List<Todo> todos, MediaType contentType, HttpOutputMessage message)
			throws IOException, HttpMessageNotWritableException {
		try (PrintWriter writer = new PrintWriter(message.getBody())) {
			todos.forEach(todo -> {
				writer.println(todo.getId() + "," + todo.getTitle() + "," + todo.getDueDate() + "," + todo.isCompleted());
			});
		}
	}
}
