package org.example.todo;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.reactive.AutoConfigureWebTestClient;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.web.reactive.server.WebTestClient;
import reactor.core.publisher.Mono;

import java.util.Date;

import static org.springframework.boot.test.context.SpringBootTest.WebEnvironment;
import static org.springframework.http.MediaType.APPLICATION_JSON;

@AutoConfigureWebTestClient
@SpringBootTest(webEnvironment = WebEnvironment.RANDOM_PORT)
public class TodoWebClientIT {

	private static final String BASE_PATH = "/todos";

	@Autowired
	private WebTestClient webTestClient;

	@Test
	public void addTodo() {
		Todo todo = new Todo("Test", new Date());
		webTestClient.post()
				.uri(BASE_PATH)
				.contentType(APPLICATION_JSON)
				.body(Mono.just(todo), Todo.class)
				.exchange()
				.expectStatus().isCreated()
				.expectHeader().contentType(APPLICATION_JSON)
				.expectBody().jsonPath("$").isNumber();
	}

	@Test
	public void getTodos() {
		webTestClient.get()
				.uri(BASE_PATH)
				.accept(APPLICATION_JSON)
				.exchange()
				.expectStatus().isOk()
				.expectHeader().contentType(APPLICATION_JSON)
				.expectBody().jsonPath("$").isNotEmpty();
	}

	@Test
	public void findTodo() {
		webTestClient.get()
				.uri(BASE_PATH + "/" + 1)
				.accept(APPLICATION_JSON)
				.exchange()
				.expectStatus().isOk()
				.expectHeader().contentType(APPLICATION_JSON)
				.expectBody().jsonPath("id").isEqualTo(1);
	}

	@Test
	public void completeTodo() {
		Todo todo = new Todo(2, "Test", new Date());
		todo.setCompleted(true);
		webTestClient.put()
				.uri(BASE_PATH + "/" + 2)
				.contentType(APPLICATION_JSON)
				.body(Mono.just(todo), Todo.class)
				.exchange()
				.expectStatus().isNoContent();
	}

	@Test
	public void deleteTodo() {
		webTestClient.delete()
				.uri(BASE_PATH + "/" + 3)
				.exchange()
				.expectStatus().isNoContent();
	}
}
