package org.example;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.phase.Phase;

import jakarta.xml.bind.JAXBException;
import javax.xml.namespace.QName;

public class AuthOutInterceptor extends AbstractSoapInterceptor {

	private static final QName HEADER_NAME = new QName("http://example.org/todo", "AuthToken");
	private static final String AUTH_TOKEN = "12345678";

	public AuthOutInterceptor() {
		super(Phase.PRE_PROTOCOL);
	}

	@Override
	public void handleMessage(SoapMessage message) {
		try {
			Header header = new Header(HEADER_NAME, AUTH_TOKEN, new JAXBDataBinding(String.class));
			message.getHeaders().add(header);
		} catch (JAXBException ex) {
			throw new RuntimeException(ex);
		}
	}
}
