package org.example;

import org.example.todo.TodoList;
import org.example.todo.TodoListService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import jakarta.xml.ws.BindingProvider;

import static jakarta.xml.ws.BindingProvider.ENDPOINT_ADDRESS_PROPERTY;

@Configuration
public class WebClientConfig {

	@Value("${endpoint.address:}")
	private String endpointAddress;

	@Bean
	public TodoList todoList() {
		TodoListService todoListService = new TodoListService();
		TodoList todoList = todoListService.getTodoListPort();
		if (!endpointAddress.isEmpty()) {
			((BindingProvider) todoList).getRequestContext().put(ENDPOINT_ADDRESS_PROPERTY, endpointAddress);
		}
		return todoList;
	}
}
