package org.example.todo;

import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TypeMapper {

	public static Date map(XMLGregorianCalendar calendar) {
		try {
			return calendar.toGregorianCalendar().getTime();
		} catch (Exception ex) {
			return null;
		}
	}

	public static XMLGregorianCalendar map(Date date) {
		try {
			GregorianCalendar calendar = new GregorianCalendar();
			calendar.setTime(date);
			return DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
		} catch (Exception ex) {
			return null;
		}
	}

	public static TodoEntity map(Todo todo) {
		TodoEntity entity = new TodoEntity();
		entity.setId(todo.getId());
		entity.setTitle(todo.getTitle());
		entity.setDueDate(map(todo.getDueDate()));
		entity.setCompleted(todo.isCompleted());
		return entity;
	}

	public static Todo map(TodoEntity entity) {
		Todo todo = new Todo();
		todo.setId(entity.getId());
		todo.setTitle(entity.getTitle());
		todo.setDueDate(map(entity.getDueDate()));
		todo.setCompleted(entity.isCompleted());
		return todo;
	}
}
